
; =============== S U B R O U T I N E =======================================

Splash_Screen:
		jsr	(PaletteFadeOut).l
		move	#$2700,sr
		move.w	(v_vdp_buffer1).w,d0
		andi.b	#$BF,d0
		move.w	d0,(vdp_control_port).l
		jsr	(ClearScreen).l
		lea	(vdp_control_port).l,a6
		move.w	#$8004,(a6)
		move.w	#$8230,(a6)
		move.w	#$8407,(a6)
		move.w	#$8230,(a6)
		move.w	#$8700,(a6)
		move.w  	#$8720,(a6)
		move.w	#$8C81,(a6)
		move.w  	#$9001,(a6)
		move.w	#$8B00,(a6)
		lea	($FFFFAC00).w,a1		; Sprite table input
		moveq	#0,d0
		move.w	#$FF,d1

@loop
		move.l	d0,(a1)+
		dbf	d1,@loop
		lea	($FFFFD000).w,a1		; Object Ram
		moveq	#0,d0
		move.w	#$7FF,d1

@loop1
		move.l	d0,(a1)+
		dbf	d1,@loop1

; Load Art BG
		locVRAM	$20						; VRAM
		lea	(ArtBG_Splash_Screen).l,a0
		jsr	(NemDec).l
		lea	(MapBG_Splash_Screen).l,a0
		lea	($FF0000).l,a1				; RAM start
		move.w	#1,d0
		jsr	(EniDec).l
		copyTilemap	$FF0000,$C000,$27,$1B

; Load Palette
		lea	(Pal_Splash_Screen).l,a0		; Load full palette
		lea	($FFFFFB80).w,a1				; Target palette
		moveq	#$1F,d0

@loop2
		move.l	(a0)+,(a1)+
		dbf	d0,@loop2
		moveq	#plcid_Main,d0
		jsr	(NewPLC).l
		move.b	#0,(v_lastlamp).w ; clear lamppost counter
		move.w	#0,(v_debuguse).w ; disable debug item placement mode
		move.w	#0,(f_demo).w	; disable debug mode
		move.w	#0,($FFFFFFEA).w ; unused variable
		move.w	#(id_GHZ<<8),(v_zone).w	; set level to GHZ (00)
		move.w	#$180,(v_demolength).l	; Timer
		move.b	#4,(v_vbla_routine).w
		jsr	(WaitForVBla).l
		move.w	(v_vdp_buffer1).w,d0
		ori.b	#$40,d0
		move.w	d0,(vdp_control_port).l
		jsr	(PaletteFadeIn).l

@loop3
		move.b	#4,(v_vbla_routine).w
		jsr	(WaitForVBla).l
		tst.w	(v_demolength).l
		beq.s	@End
		tst.b (v_jpadpress1).w
		bpl.s	@loop3
@End
		jmp	(PlayLevel).l

; =============== S U B R O U T I N E =======================================

; Resources
Pal_Splash_Screen:		incbin	"#Splash Screen\pal.bin"
	even
ArtBG_Splash_Screen:		incbin	"#Splash Screen\artnem.bin"
	even
MapBG_Splash_Screen:	incbin	"#Splash Screen\mapeni.bin"
	even
